using System;
using System.Drawing;
using System.Drawing.Printing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using IDAutomation.Windows.Forms.LinearBarCode;
namespace C_Sharp_Example
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class frmCSharpExample : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.CheckBox chkShowCheckDigit;
		internal System.Windows.Forms.CheckBox chkShowText;
		internal System.Windows.Forms.CheckBox chkUseCheckDigit;
		internal System.Windows.Forms.Label Label1;
		internal System.Windows.Forms.Label Label2;
		internal System.Windows.Forms.Button cmdPrint;
		internal System.Windows.Forms.Button cmdExit;
		internal System.Windows.Forms.ComboBox cboSymbology;
		internal System.Windows.Forms.TextBox txtDataToEncode;
		internal System.Windows.Forms.CheckBox checkBox1;
		internal System.Windows.Forms.CheckBox checkBox2;
		private IDAutomation.Windows.Forms.LinearBarCode.Barcode barcode2;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmCSharpExample()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.chkShowCheckDigit = new System.Windows.Forms.CheckBox();
			this.chkShowText = new System.Windows.Forms.CheckBox();
			this.chkUseCheckDigit = new System.Windows.Forms.CheckBox();
			this.Label1 = new System.Windows.Forms.Label();
			this.Label2 = new System.Windows.Forms.Label();
			this.cmdPrint = new System.Windows.Forms.Button();
			this.cmdExit = new System.Windows.Forms.Button();
			this.cboSymbology = new System.Windows.Forms.ComboBox();
			this.txtDataToEncode = new System.Windows.Forms.TextBox();
			this.checkBox1 = new System.Windows.Forms.CheckBox();
			this.checkBox2 = new System.Windows.Forms.CheckBox();
			this.barcode2 = new IDAutomation.Windows.Forms.LinearBarCode.Barcode();
			this.SuspendLayout();
			// 
			// chkShowCheckDigit
			// 
			this.chkShowCheckDigit.Location = new System.Drawing.Point(10, 242);
			this.chkShowCheckDigit.Name = "chkShowCheckDigit";
			this.chkShowCheckDigit.Size = new System.Drawing.Size(123, 45);
			this.chkShowCheckDigit.TabIndex = 19;
			this.chkShowCheckDigit.Text = "Show Check Digit In Text";
			this.chkShowCheckDigit.CheckedChanged += new System.EventHandler(this.chkShowCheckDigit_CheckedChanged);
			// 
			// chkShowText
			// 
			this.chkShowText.Location = new System.Drawing.Point(145, 240);
			this.chkShowText.Name = "chkShowText";
			this.chkShowText.Size = new System.Drawing.Size(121, 49);
			this.chkShowText.TabIndex = 18;
			this.chkShowText.Text = "Show Human Readable Text";
			this.chkShowText.CheckedChanged += new System.EventHandler(this.chkShowText_CheckedChanged);
			// 
			// chkUseCheckDigit
			// 
			this.chkUseCheckDigit.Location = new System.Drawing.Point(278, 239);
			this.chkUseCheckDigit.Name = "chkUseCheckDigit";
			this.chkUseCheckDigit.Size = new System.Drawing.Size(106, 51);
			this.chkUseCheckDigit.TabIndex = 17;
			this.chkUseCheckDigit.Text = "Use Check Digit";
			this.chkUseCheckDigit.CheckedChanged += new System.EventHandler(this.chkUseCheckDigit_CheckedChanged);
			// 
			// Label1
			// 
			this.Label1.AutoSize = true;
			this.Label1.Location = new System.Drawing.Point(141, 171);
			this.Label1.Name = "Label1";
			this.Label1.Size = new System.Drawing.Size(118, 19);
			this.Label1.TabIndex = 21;
			this.Label1.Text = "Data To Barcode";
			// 
			// Label2
			// 
			this.Label2.AutoSize = true;
			this.Label2.Location = new System.Drawing.Point(160, 99);
			this.Label2.Name = "Label2";
			this.Label2.Size = new System.Drawing.Size(82, 19);
			this.Label2.TabIndex = 22;
			this.Label2.Text = "Symbology";
			// 
			// cmdPrint
			// 
			this.cmdPrint.Location = new System.Drawing.Point(219, 300);
			this.cmdPrint.Name = "cmdPrint";
			this.cmdPrint.Size = new System.Drawing.Size(120, 38);
			this.cmdPrint.TabIndex = 25;
			this.cmdPrint.Text = "Print Barcode";
			this.cmdPrint.Click += new System.EventHandler(this.cmdPrint_Click);
			// 
			// cmdExit
			// 
			this.cmdExit.Location = new System.Drawing.Point(56, 300);
			this.cmdExit.Name = "cmdExit";
			this.cmdExit.Size = new System.Drawing.Size(120, 38);
			this.cmdExit.TabIndex = 24;
			this.cmdExit.Text = "Exit";
			this.cmdExit.Click += new System.EventHandler(this.cmdExit_Click);
			// 
			// cboSymbology
			// 
			this.cboSymbology.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cboSymbology.Location = new System.Drawing.Point(73, 124);
			this.cboSymbology.Name = "cboSymbology";
			this.cboSymbology.Size = new System.Drawing.Size(248, 27);
			this.cboSymbology.Sorted = true;
			this.cboSymbology.TabIndex = 23;
			this.cboSymbology.SelectedIndexChanged += new System.EventHandler(this.cboSymbology_SelectedIndexChanged);
			// 
			// txtDataToEncode
			// 
			this.txtDataToEncode.Location = new System.Drawing.Point(80, 193);
			this.txtDataToEncode.Name = "txtDataToEncode";
			this.txtDataToEncode.Size = new System.Drawing.Size(240, 26);
			this.txtDataToEncode.TabIndex = 20;
			this.txtDataToEncode.Text = "";
			this.txtDataToEncode.TextChanged += new System.EventHandler(this.txtDataToEncode_TextChanged);
			// 
			// checkBox1
			// 
			this.checkBox1.Location = new System.Drawing.Point(16, 236);
			this.checkBox1.Name = "checkBox1";
			this.checkBox1.Size = new System.Drawing.Size(121, 49);
			this.checkBox1.TabIndex = 19;
			this.checkBox1.Text = "Show Check Digit In Text";
			// 
			// checkBox2
			// 
			this.checkBox2.Location = new System.Drawing.Point(285, 239);
			this.checkBox2.Name = "checkBox2";
			this.checkBox2.Size = new System.Drawing.Size(121, 49);
			this.checkBox2.TabIndex = 17;
			this.checkBox2.Text = "Use Check Digit";
			// 
			// barcode2
			// 
			this.barcode2.ApplyTilde = false;
			this.barcode2.BackColor = System.Drawing.Color.White;
			this.barcode2.BarHeightCM = "1.000";
			this.barcode2.CheckCharacter = true;
			this.barcode2.CheckCharacterInText = false;
			this.barcode2.CODABARStartChar = "A";
			this.barcode2.CODABARStopChar = "B";
			this.barcode2.Code128Set = IDAutomation.Windows.Forms.LinearBarCode.Barcode.Code128CharacterSets.Auto;
			this.barcode2.DataToEncode = "12345678";
			this.barcode2.FitControlToBarcode = true;
			this.barcode2.LeftMarginCM = "0.200";
			this.barcode2.Location = new System.Drawing.Point(145, 15);
			this.barcode2.Name = "barcode2";
			this.barcode2.NarrowToWideRatio = "2.0";
			this.barcode2.PostnetHeightShort = "0.051";
			this.barcode2.PostnetHeightTall = "0.126";
			this.barcode2.PostnetSpacing = "0.085";
			this.barcode2.Resolution = IDAutomation.Windows.Forms.LinearBarCode.Barcode.Resolutions.Screen;
			this.barcode2.ResolutionCustomDPI = "96.00";
			this.barcode2.RotationAngle = IDAutomation.Windows.Forms.LinearBarCode.Barcode.RotationAngles.Zero_Degrees;
			this.barcode2.ShowText = true;
			this.barcode2.Size = new System.Drawing.Size(104, 69);
			this.barcode2.SupplementHeight = "0.80";
			this.barcode2.SupplementToEncode = "";
			this.barcode2.SuppSeparationCM = "0.500";
			this.barcode2.SymbologyID = IDAutomation.Windows.Forms.LinearBarCode.Barcode.Symbologies.Code128;
			this.barcode2.TabIndex = 26;
			this.barcode2.TextFontColor = System.Drawing.Color.Black;
			this.barcode2.TextMarginCM = "0.100";
			this.barcode2.TopMarginCM = "0.200";
			this.barcode2.UPCEANSupplement2 = false;
			this.barcode2.UPCEANSupplement5 = false;
			this.barcode2.UPCESystem = "1";
			this.barcode2.XDimensionCM = "0.0300";
			// 
			// frmCSharpExample
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(7, 19);
			this.ClientSize = new System.Drawing.Size(395, 339);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.barcode2,
																		  this.Label1,
																		  this.Label2,
																		  this.cmdPrint,
																		  this.cmdExit,
																		  this.cboSymbology,
																		  this.txtDataToEncode,
																		  this.chkShowCheckDigit,
																		  this.chkShowText,
																		  this.chkUseCheckDigit,
																		  this.checkBox1,
																		  this.checkBox2});
			this.Font = new System.Drawing.Font("Times New Roman", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D;
			this.Name = "frmCSharpExample";
			this.Text = "IDAutomation.com C# Example for Linear Barcode";
			this.Load += new System.EventHandler(this.frmCSharpExample_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new frmCSharpExample());
		}

		private void frmCSharpExample_Load(object sender, System.EventArgs e)
		{
			cboSymbology.Items.Add("CODE11");
			cboSymbology.Items.Add("CODE39");
			cboSymbology.Items.Add("CODE39EXT");
			cboSymbology.Items.Add("INTERLEAVED25");
			cboSymbology.Items.Add("CODABAR");
			cboSymbology.Items.Add("MSI");
			cboSymbology.Items.Add("UPCA");
			cboSymbology.Items.Add("IND25");
			cboSymbology.Items.Add("MAT25");
			cboSymbology.Items.Add("EAN13");
			cboSymbology.Items.Add("EAN8");
			cboSymbology.Items.Add("UPCE");
			cboSymbology.Items.Add("CODE128");
			cboSymbology.Items.Add("CODE93");
			cboSymbology.Items.Add("CODE93EXT");
			cboSymbology.Items.Add("POSTNET");
			cboSymbology.Items.Add("PLANET");

			txtDataToEncode.Text = barcode2.DataToEncode;

			SetSymbologyBoxEntry();

			chkUseCheckDigit.Checked = barcode2.CheckCharacter;
			chkShowText.Checked = barcode2.ShowText;
			chkShowCheckDigit.Checked = barcode2.CheckCharacterInText;
		}
		private void SetSymbologyBoxEntry()
		{
			string SymbID = "";
			if( barcode2.SymbologyID == Barcode.Symbologies.Codabar )
				SymbID = "CODABAR";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Code11)
				SymbID = "CODE11";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Code128 )
				SymbID = "CODE128";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Code39 )
				SymbID = "CODE39";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Code39Ext )
				SymbID = "CODE39EXT";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Code93 )
				SymbID = "CODE93";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Code93Ext )
				SymbID = "CODE93EXT";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Ean13 )
				SymbID = "EAN13";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Ean8 )
				SymbID = "EAN8";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Ind25 )
				SymbID = "IND25";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Interleaved25 )
				SymbID = "INTERLEAVED25";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Mat25 )
				SymbID = "MAT25";
			else if( barcode2.SymbologyID == Barcode.Symbologies.MSI )
				SymbID = "MSI";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Planet )
				SymbID = "PLANET";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Postnet )
				SymbID = "POSTNET";
			else if( barcode2.SymbologyID == Barcode.Symbologies.UPCa )
				SymbID = "UPCA";
			else if( barcode2.SymbologyID == Barcode.Symbologies.UPCe )
				SymbID = "UPCE";

			int cboIndex = 0;
			cboIndex = cboSymbology.FindStringExact(SymbID);
			cboSymbology.SelectedIndex = cboIndex;

			UpdateFormCaption();
		}
		
		private void UpdateFormCaption()
		{
			if( barcode2.SymbologyID == Barcode.Symbologies.Codabar )
				this.Text = "IDAutomation Example - " + "Barcoding with Codabar";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Code11 )
				this.Text = "IDAutomation Example - " + "Barcoding with Code11";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Code128 )
			{
                if( barcode2.Code128Set == Barcode.Code128CharacterSets.A )
					this.Text = "IDAutomation Example - " + "Barcoding with Code128 Set A";
                else if( barcode2.Code128Set == Barcode.Code128CharacterSets.B )
					this.Text = "IDAutomation Example - " + "Barcoding with Code128 Set B";
				else if( barcode2.Code128Set == Barcode.Code128CharacterSets.C )
					this.Text = "IDAutomation Example - " + "Barcoding with Code128 Set C";
				else if( barcode2.Code128Set == Barcode.Code128CharacterSets.Auto )
					this.Text = "IDAutomation Example - " + "Barcoding with Code128 Auto";
			}
			else if( barcode2.SymbologyID == Barcode.Symbologies.Code39 )
				this.Text = "IDAutomation Example - " + "Barcoding with Code39";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Code39Ext )
				this.Text = "IDAutomation Example - " + "Barcoding with Code39 Extended";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Code93 )
				this.Text = "IDAutomation Example - " + "Barcoding with Code93";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Code93Ext )
				this.Text = "IDAutomation Example - " + "Barcoding with Code93 Extended";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Ean13 )
				this.Text = "IDAutomation Example - " + "Barcoding with EAN-13";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Ean8 )
				this.Text = "IDAutomation Example - " + "Barcoding with EAN-8";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Ind25 )
				this.Text = "IDAutomation Example - " + "Barcoding with Industrial 2 of 5";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Interleaved25 )
				this.Text = "IDAutomation Example - " + "Barcoding with Interleaved 2 of 5";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Mat25 )
				this.Text = "IDAutomation Example - " + "Barcoding with MAT 2 of 5";
			else if( barcode2.SymbologyID == Barcode.Symbologies.MSI )
				this.Text = "IDAutomation Example - " + "Barcoding with MSI Plessey";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Planet )
				this.Text = "IDAutomation Example - " + "Barcoding with Planet";
			else if( barcode2.SymbologyID == Barcode.Symbologies.Postnet )
				this.Text = "IDAutomation Example - " + "Barcoding with Postnet";
			else if( barcode2.SymbologyID == Barcode.Symbologies.UPCa )
				this.Text = "IDAutomation Example - " + "Barcoding with UPC-A";
			else if( barcode2.SymbologyID == Barcode.Symbologies.UPCe )
				this.Text = "IDAutomation Example - " + "Barcoding with UPC-E";
		
		}
		
		protected override void OnPaint(System.Windows.Forms.PaintEventArgs pea)
		{
			UpdateFormCaption();
		}

		private void txtDataToEncode_TextChanged(object sender, System.EventArgs e)
		{
			barcode2.DataToEncode = txtDataToEncode.Text;
		}

		private void cboSymbology_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if( cboSymbology.SelectedItem.ToString() == "CODE128" )
				barcode2.SymbologyID = Barcode.Symbologies.Code128;
			else if( cboSymbology.SelectedItem.ToString() == "CODABAR" )
				barcode2.SymbologyID = Barcode.Symbologies.Codabar;
			else if( cboSymbology.SelectedItem.ToString() == "CODE11" )
				barcode2.SymbologyID = Barcode.Symbologies.Code11;
			else if( cboSymbology.SelectedItem.ToString() == "CODE39" )
				barcode2.SymbologyID = Barcode.Symbologies.Code39;
			else if( cboSymbology.SelectedItem.ToString() == "CODE39EXT" )
				barcode2.SymbologyID = Barcode.Symbologies.Code39Ext;
			else if( cboSymbology.SelectedItem.ToString() == "CODE93" )
				barcode2.SymbologyID = Barcode.Symbologies.Code93;
			else if( cboSymbology.SelectedItem.ToString() == "CODE93EXT" )
				barcode2.SymbologyID = Barcode.Symbologies.Code93Ext;
			else if( cboSymbology.SelectedItem.ToString() == "EAN13" )
				barcode2.SymbologyID = Barcode.Symbologies.Ean13;
			else if( cboSymbology.SelectedItem.ToString() == "EAN8" )
				barcode2.SymbologyID = Barcode.Symbologies.Ean8;
			else if( cboSymbology.SelectedItem.ToString() == "IND25" )
				barcode2.SymbologyID = Barcode.Symbologies.Ind25;
			else if( cboSymbology.SelectedItem.ToString() == "INTERLEAVED25" )
				barcode2.SymbologyID = Barcode.Symbologies.Interleaved25;
			else if( cboSymbology.SelectedItem.ToString() == "MAT25" )
				barcode2.SymbologyID = Barcode.Symbologies.Mat25;
			else if( cboSymbology.SelectedItem.ToString() == "MSI" )
				barcode2.SymbologyID = Barcode.Symbologies.MSI;
			else if( cboSymbology.SelectedItem.ToString() == "PLANET" )
				barcode2.SymbologyID = Barcode.Symbologies.Planet;
			else if( cboSymbology.SelectedItem.ToString() == "POSTNET" )
				barcode2.SymbologyID = Barcode.Symbologies.Postnet;
			else if( cboSymbology.SelectedItem.ToString() == "UPCA" )
				barcode2.SymbologyID = Barcode.Symbologies.UPCa;
			else if( cboSymbology.SelectedItem.ToString() == "UPCE" )
				barcode2.SymbologyID = Barcode.Symbologies.UPCe;
			
			UpdateFormCaption();
		}

		private void chkUseCheckDigit_CheckedChanged(object sender, System.EventArgs e)
		{
			if( chkUseCheckDigit.Checked == true )
				barcode2.CheckCharacter = true;
			else
				barcode2.CheckCharacter = false;
		}

		private void chkShowText_CheckedChanged(object sender, System.EventArgs e)
		{
			if( chkShowText.Checked == true )
				barcode2.ShowText = true;
			else
				barcode2.ShowText = false;
		}

		private void chkShowCheckDigit_CheckedChanged(object sender, System.EventArgs e)
		{
			if( chkShowCheckDigit.Checked == true)
				barcode2.CheckCharacterInText = true;
			else
				barcode2.CheckCharacterInText = false;
		}

		private void cmdExit_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void cmdPrint_Click(object sender, System.EventArgs e)
		{
			//This is the event handler to print the image of this barcode on the printer
			//Make sure that system.drawing.printing is imported to use this

			//Create the document object that we are sending to the printer
			PrintDocument prndoc = new PrintDocument(); 

			//Give the document a title.  This is what displays in the Printers Control Panel item
			prndoc.DocumentName = "Printing a Barcode";

			//Add an event handler to handle any additional processing that may need to occur, such
			//as positioning of text
			
			prndoc.PrintPage += new System.Drawing.Printing.PrintPageEventHandler(this.PrintDocumentOnPrintPage );

			//Initiate the printing of the page.  PrintDocumentOnPrintPage will be handled next
			prndoc.Print();
		}

		private void PrintDocumentOnPrintPage(object sender, PrintPageEventArgs ppea )
		{
			Graphics grfx = ppea.Graphics;
			System.Drawing.Imaging.Metafile myImage; 
			
			grfx.DrawString(this.Text, this.Font, Brushes.Black, 0, 0);

			myImage = barcode2.Picture;
			grfx.DrawImage(myImage, 0, 40);
			return;
		}
	}
}
